from django.shortcuts import render,redirect
from django.http import HttpResponseRedirect
from django.contrib.auth.decorators import login_required
from app1.models import Employee
from app1.forms import EmployeeForm
from app1.models import New
from app1.forms import NewForm
from app1.models import Calender
from app1.forms import CalenderForm


# Create your views here.

def home_view(request):
 	return render(request,'app1/home.html')
@login_required
def hr_view(request):
 	return render(request,'app1/hr.html')


def emp_view(request):
	form = EmployeeForm()
	if request.method =="POST":
		form=EmployeeForm(request.POST)
		if form.is_valid():
			form.save()
			return HttpResponseRedirect("/employee/")
	return render(request,'app1/employee.html',{'form':form})

def data_view(request):
	employees = Employee.objects.all()
	return render(request,'app1/data.html',{'e':employees})


def delete_view(request,id):
	employee=Employee.objects.get(id=id)
	employee.delete()
	return redirect('/data')

def update_view(request,id):
	employee=Employee.objects.get(id=id)
	if request.method=='POST':
		form=EmployeeForm(request.POST,instance=employee)
		if form.is_valid():
			form.save()
			return redirect('/data/')
	return render(request,'app1/update.html',{'employee':employee})

def news_view(request):
	form=NewForm()
	if request.method =="POST":
		form=NewForm(request.POST)
		if form.is_valid():
			form.save()
			return redirect('/data1')
	return render(request,'app1/news.html',{'form':form})

def data1_view(request):
	news=New.objects.all()
	return render(request,'app1/data1.html',{'n':news})

def calender_view(request):
	form=CalenderForm()
	if request.method =="POST":
		form=CalenderForm(request.POST)
		if form.is_valid():
			form.save()
			return redirect('/data2')
	return render(request,'app1/calender.html',{'form':form})

def data2(request):
	calender=Calender.objects.all()
	return render(request,'app1/data2.html',{'c':calender})