const express = require('express');
const ejs = require('ejs');
const path = require('path');
const qrcode = require('qrcode');
const app = express();
const port = 8080;

app.use(express.json());
app.use(express.urlencoded({ extended:false }));

app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'view'));

app.get('/', (req,res) => {
    res.render('index')
})

app.use(express.static('public'));

app.post('/scan', (req, res) => {
    const input_text = req.body.text;
    qrcode.toDataURL(input_text,(err, src) => {
        res.render('scan',{
            qr_code:src,
        });
    })
})

app.listen(port, () => {
	console.log('The server is listening on port 8080');
})