import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.*;
public class LoginApplication extends JFrame {
    private JTextField usernameField;
    private JPasswordField passwordField;
    public LoginApplication() {
        // Set up the frame
        setTitle("Login Application");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(300, 200);
        setLocationRelativeTo(null); // Center the frame on the screen
        // Create the components
        JLabel usernameLabel = new JLabel("Username:");
        JLabel passwordLabel = new JLabel("Password:");
        usernameField = new JTextField(20);
        passwordField = new JPasswordField(20);
        JButton loginButton = new JButton("Login");
        // Create a panel and set the layout
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 2, 10, 10));
        panel.add(usernameLabel);
        panel.add(usernameField);
        panel.add(passwordLabel);
        panel.add(passwordField);
        panel.add(new JLabel()); // Empty label for spacing
        panel.add(loginButton);
        // Add the panel to the frame
        add(panel);
        // Add an action listener to the login button
        loginButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String username = usernameField.getText();
                String password = new String(passwordField.getPassword());
                // Call the method for validating the login
                boolean isValid = validateLogin(username, password);
                if (isValid) {
                    JOptionPane.showMessageDialog(LoginApplication.this, "Login successful!");
                    // Open the main application window or perform other actions
                } else {
                    JOptionPane.showMessageDialog(LoginApplication.this, "Invalid username or password. Please try again.");
                }
            }
        });
    }
    // Method for validating the login
    private boolean validateLogin(String username, String password) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            // Establish a connection to the MySQL database
            conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/db", "root", "password");
            // Prepare the SQL query
            String sql = "SELECT * FROM table1 WHERE username = ? AND password = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, username);
            stmt.setString(2, password);
            // Execute the query
            rs = stmt.executeQuery();
            // Check if a matching record is found
            return rs.next();
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        } finally {
            // Close the resources
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                LoginApplication loginApp = new LoginApplication();
                loginApp.setVisible(true);
            }
        });
    }
}
